import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class Default {
	public static String apiKey = "ApiKey";
	
	public static void main(String[] args) throws Exception {
		try
		{
			//System.out.println("sendEmail Json");
			//sendEmail();
			
			//System.out.println("sendSms Json");
			//sendSms();
			
			//System.out.println("getEmailByIds Json");
			//getEmailByIds();
			
			//System.out.println("getSmsIds Json");
			//getSmsIds();
			
			//System.out.println("getSmsStats Json");
			//getSmsStats();
			
			//System.out.println("getEmailStats Json");
			//getEmailStats();
			
			//System.out.println("getSmsStats Json");
			//getSmsList();
			
			//System.out.println("getEmailStats Json");
			//getEmailList();
		}
		catch(Exception ex)
		{
			System.out.println(ex.getMessage());
		}
	}

	private static void getEmailByIds() throws Exception {

		String url = "https://messagingapis.paylite.net/api/messagingdata/GetEmailByIds";
		
		Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
		
        JsonArray emailIds = new JsonArray();
        emailIds.add(new JsonPrimitive("11d26b81-ad9e-456c-8448-f7ba7e5f6323"));
        //emailIds.add(new JsonPrimitive("ad9b39d8-69aa-4f2e-89d3-5669819c9f77"));
        
        JsonObject jsonData = new JsonObject();
		jsonData.addProperty("ApiKey", apiKey);
		jsonData.add("EmailIds", emailIds);
		
		String postJsonData = gson.toJson(jsonData);
		System.out.println(postJsonData);
		
		postRequest(url,postJsonData);
	}
	
	private static void getSmsIds() throws Exception {

		String url = "https://messagingapis.paylite.net/api/messagingdata/GetSmsByIds";
		
		Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
		
        JsonArray smsIds = new JsonArray();
        smsIds.add(new JsonPrimitive("103bfa1b-b8de-4d44-aa59-0ea04fde1271"));
        smsIds.add(new JsonPrimitive("1a3b082b-e4ed-4f30-8ee0-680c4c02b953"));
        
        JsonObject jsonData = new JsonObject();
		jsonData.addProperty("ApiKey", apiKey);
		jsonData.add("SmsIds", smsIds);
		
		String postJsonData = gson.toJson(jsonData);
		System.out.println(postJsonData);
		
		postRequest(url,postJsonData);
	}
	
	private static void sendEmail() throws Exception {

		String url = "https://messagingapis.paylite.net/api/email/send";
		
		Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
		
		JsonObject fromEmail = new JsonObject();
		fromEmail.addProperty("Email", "support@paylite.net");
		fromEmail.addProperty("Name", "Support PayLite");
		
		JsonArray toEmails = new JsonArray();
		JsonObject toEmail = new JsonObject();
		toEmail.addProperty("Email", "contactanmol@gmail.com");
		toEmail.addProperty("Name", "Anmol Singh");
		toEmails.add(toEmail);
		
        JsonObject jsonData = new JsonObject();
		jsonData.addProperty("ApiKey", apiKey);
		jsonData.add("FromEmail", fromEmail);
		jsonData.add("ToEmail", toEmails);
		jsonData.addProperty("Subject", "Paylite Messaging");
		jsonData.addProperty("HtmlContent", "PayLite test content");
		
		String postJsonData = gson.toJson(jsonData);
		System.out.println(postJsonData);
		
		postRequest(url,postJsonData);
	}
	
	private static void sendSms() throws Exception {

		String url = "https://messagingapis.paylite.net/api/sms/send";
		
		Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
		
        JsonObject jsonData = new JsonObject();
		jsonData.addProperty("ApiKey", apiKey);
		jsonData.addProperty("ToNumber", "9176059465");
		jsonData.addProperty("TextMessage", "Test Message");
		
		String postJsonData = gson.toJson(jsonData);
		System.out.println(postJsonData);
		
		postRequest(url,postJsonData);
	}
	
	private static void getSmsStats() throws Exception {

		String url = "https://messagingapis.paylite.net/api/messagingdata/getsmsstats";
		
		Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
		
        JsonObject jsonData = new JsonObject();
		jsonData.addProperty("ApiKey", apiKey);
		jsonData.addProperty("StartDate", "1/1/2018");
		jsonData.addProperty("EndDate", "1/23/2018");
		
		String postJsonData = gson.toJson(jsonData);
		System.out.println(postJsonData);
		
		postRequest(url,postJsonData);
	}
	
	private static void getEmailStats() throws Exception {

		String url = "https://messagingapis.paylite.net/api/messagingdata/getemailstats";
		
		Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
		
        JsonObject jsonData = new JsonObject();
		jsonData.addProperty("ApiKey", apiKey);
		jsonData.addProperty("StartDate", "1/1/2018");
		jsonData.addProperty("EndDate", "1/23/2018");
		
		String postJsonData = gson.toJson(jsonData);
		System.out.println(postJsonData);
		
		postRequest(url,postJsonData);
	}
	
	private static void getEmailList() throws Exception {

		String url = "https://messagingapis.paylite.net/api/messagingdata/getemaillist";
		
		Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
		
        JsonObject jsonData = new JsonObject();
		jsonData.addProperty("ApiKey", apiKey);
		jsonData.addProperty("StartDate", "1/1/2018");
		jsonData.addProperty("EndDate", "1/23/2018");
		
		String postJsonData = gson.toJson(jsonData);
		System.out.println(postJsonData);
		
		postRequest(url,postJsonData);
	}
	
	private static void getSmsList() throws Exception {

		String url = "https://messagingapis.paylite.net/api/messagingdata/getsmslist";
		
		Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
		
        JsonObject jsonData = new JsonObject();
		jsonData.addProperty("ApiKey", apiKey);
		jsonData.addProperty("StartDate", "1/1/2018");
		jsonData.addProperty("EndDate", "1/23/2018");
		
		String postJsonData = gson.toJson(jsonData);
		System.out.println(postJsonData);
		
		postRequest(url,postJsonData);
	}
	
	private static void postRequest(String url, String postJsonData) throws Exception {
		URL obj = new URL(url);
		HttpURLConnection con = (HttpURLConnection) obj.openConnection();

		// Setting basic post request
		con.setRequestMethod("POST");
		con.setRequestProperty("Content-Type", "application/json");

		// Send post request
		con.setDoOutput(true);
		DataOutputStream wr = new DataOutputStream(con.getOutputStream());
		wr.writeBytes(postJsonData);
		wr.flush();
		wr.close();

		//Read output
		BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
		String output;
		StringBuffer response = new StringBuffer();

		while ((output = in.readLine()) != null) {
			response.append(output);
		}
		in.close();

		// printing result from response
		System.out.println(response.toString());
	}
}
